DROP TABLE IF EXISTS `gx_configurations`;

CREATE TABLE IF NOT EXISTS `gx_configurations` (
	`id`              int(11)      NOT NULL AUTO_INCREMENT,
	`key`             varchar(255) NOT NULL,
	`language_id`     int(11)           DEFAULT NULL,
	`value`           mediumtext,
	`default`         mediumtext,
	`type`            varchar(255)      DEFAULT NULL,
	`sort_order`      int(5)            DEFAULT NULL,
	`legacy_group_id` int(11)           DEFAULT NULL,
	`last_modified`   timestamp    NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	UNIQUE KEY `uc_cfg_key`(`key`, `language_id`),
	KEY `key`(`key`)
)
	ENGINE = InnoDB
	DEFAULT CHARSET = `utf8`;

CREATE INDEX `key` ON `gx_configurations`(`key`);

INSERT INTO `gx_configurations` (`key`, `language_id`, `value`, `default`, `type`, `sort_order`,
                                 `legacy_group_id`)
VALUES ('configuration/ACCOUNT_B2B_STATUS', NULL, 'false', 'false', 'switcher', 7, 5),
('configuration/ACCOUNT_COMPANY', NULL, 'true', 'true', 'switcher', 3, 5),
('configuration/ACCOUNT_COMPANY_VAT_CHECK', NULL, 'true', 'true', 'switcher', 4, 18),
('configuration/ACCOUNT_COMPANY_VAT_GROUP', NULL, 'false', 'false', 'switcher', 4, 18),
('configuration/ACCOUNT_COMPANY_VAT_LIVE_CHECK', NULL, 'true', 'true', 'switcher', 4, 18),
('configuration/ACCOUNT_DEFAULT_B2B_STATUS', NULL, 'false', 'false', 'switcher', 8, 5),
('configuration/ACCOUNT_DOB', NULL, 'false', 'false', 'switcher', 2, 5),
('configuration/ACCOUNT_FAX', NULL, 'true', 'true', 'switcher', 1, 5),
('configuration/ACCOUNT_GENDER', NULL, 'true', 'true', 'switcher', 1, 5),
('configuration/ACCOUNT_OPTIONS', NULL, 'both', 'both', 'account-type', 6, 5),
('configuration/ACCOUNT_TYPE_DEFAULT', NULL, 'account', 'account', 'account-template', 6, 5),
('configuration/ACCOUNT_STATE', NULL, 'false', 'false', 'switcher', 5, 5),
('configuration/ACCOUNT_ADDITIONAL_INFO', NULL, 'false', 'false', 'switcher', 5, 5),
('configuration/ACCOUNT_SPLIT_STREET_INFORMATION', NULL, 'false', 'false', 'switcher', 5, 5),
('configuration/ACCOUNT_SUBURB', NULL, 'false', 'false', 'switcher', 4, 5),
('configuration/ACCOUNT_TELEPHONE', NULL, 'true', 'true', 'switcher', 1, 5),
('configuration/ACCOUNT_VAT_BLOCK_ERROR', NULL, 'true', 'true', 'switcher', 4, 18),
('configuration/ACCOUNT_NAMES_OPTIONAL', NULL, 'false', 'false', 'switcher', 9, 5),
('configuration/ACTIVATE_GIFT_SYSTEM', NULL, 'false', 'false', 'switcher', 2, 0),
('configuration/ACTIVATE_NAVIGATOR', NULL, 'false', 'false', 'switcher', 10, 17),
('configuration/ACTIVATE_PAGE_TOKEN', NULL, 'true', 'true', 'switcher', 13, 17),
('configuration/ACTIVATE_REVERSE_CROSS_SELLING', NULL, 'true', 'true', 'switcher', 12, 17),
('configuration/ACTIVATE_SHIPPING_STATUS', NULL, 'true', 'true', 'switcher', 6, 0),
('configuration/ADVANCED_SEARCH_DEFAULT_OPERATOR', NULL, 'and', 'and', 'search-operator', 30, 1),
('configuration/AFTERBUY_ACTIVATED', NULL, 'false', 'false', 'switcher', 6, 21),
('configuration/AFTERBUY_ORDERSTATUS', NULL, '1', '1', 'order-status', 5, 21),
	('configuration/AFTERBUY_PARTNERID', NULL, '', '', NULL, 2, 21),
	('configuration/AFTERBUY_PARTNERPASS', NULL, '', '', NULL, 3, 21),
	('configuration/AFTERBUY_USERID', NULL, '', '', NULL, 4, 21),
('configuration/ALLOW_ADD_TO_CART', NULL, 'false', 'false', 'switcher', 39, 1),
('configuration/APPEND_PROPERTIES_MODEL', NULL, 'true', 'true', 'switcher', 45, 1),
('configuration/ATTRIBUTE_STOCK_CHECK', NULL, 'true', 'true', 'switcher', 2, 9),
	('configuration/CACHE_CHECK', NULL, 'false', 'false', NULL, 4, 11),
	('configuration/CACHE_LIFETIME', NULL, '3600', '3600', NULL, 3, 11),
('configuration/CALCULATE_TAX_BASED_ON_VAT_ID', NULL, 'true', 'true', 'switcher', 8, 18),
('configuration/CC_KEYCHAIN', NULL, 'tobechanged', 'tobechanged', NULL, 44, 1),
('configuration/CC_NUMBER_MIN_LENGTH', NULL, '10', '10', 'number', 13, 2),
('configuration/CC_OWNER_MIN_LENGTH', NULL, '3', '3', 'number', 12, 2),
('configuration/CHECK_CLIENT_AGENT', NULL, 'true', 'true', 'switcher', 8, 15),
	('configuration/COMPANY_NAME', NULL, '', '', NULL, 3, 1),
('configuration/COMPRESS_EXPORT', NULL, 'false', 'false', NULL, 3, 20),
('configuration/CONFIG_CALCULATE_IMAGE_SIZE', NULL, 'true', 'true', 'switcher', 1, 4),
('configuration/CONTACT_US_EMAIL_ADDRESS', NULL, '', '', NULL, 20, 12),
('configuration/CONTACT_US_FORWARDING_STRING', NULL, '', '', NULL, 25, 12),
('configuration/CONTACT_US_NAME', NULL, 'Ihr Name', 'Ihr Name', NULL, 21, 12),
('configuration/CONTACT_US_REPLY_ADDRESS', NULL, '', '', NULL, 22, 12),
('configuration/CONTACT_US_REPLY_ADDRESS_NAME', NULL, 'Ihr Name', 'Ihr Name', NULL, 23, 12),
	('configuration/CSV_SEPERATOR', NULL, '|', '|', NULL, 2, 20),
	('configuration/CSV_TEXTSIGN', NULL, '', '', NULL, 1, 20),
('configuration/CURRENT_TEMPLATE', NULL, 'Honeygrid', 'Honeygrid', NULL, 41, 1),
('configuration/DATE_TIMEZONE', NULL, 'Europe/Berlin', 'Europe/Berlin', NULL, 47, 1),
	('configuration/DB_CACHE', NULL, 'false', 'false', NULL, 5, 11),
('configuration/DB_CACHE_EXPIRE', NULL, '3600', '3600', NULL, 6, 11),
('configuration/DEFAULT_CURRENCY', NULL, 'EUR', 'EUR', NULL, NULL, 6),
('configuration/DEFAULT_CUSTOMERS_STATUS_ID', NULL, '2', '2', 'default-customer-group', 38, 1),
('configuration/DEFAULT_CUSTOMERS_STATUS_ID_ADMIN', NULL, '0', '0', NULL, 35, 1),
('configuration/DEFAULT_CUSTOMERS_STATUS_ID_GUEST', NULL, '1', '1', NULL, 36, 1),
('configuration/DEFAULT_CUSTOMERS_VAT_STATUS_ID', NULL, '3', '3', 'default-customer-group', 23, 18),
('configuration/DEFAULT_CUSTOMERS_VAT_STATUS_ID_LOCAL', NULL, '3', '3', 'default-customer-group', 24, 18),
	('configuration/DEFAULT_LANGUAGE', NULL, 'de', 'de', NULL, NULL, 6),
('configuration/DEFAULT_ORDERS_STATUS_ID', NULL, '1', '1', NULL, NULL, 6),
('configuration/DEFAULT_PRODUCTS_VPE_ID', NULL, '', '', NULL, NULL, 6),
('configuration/DEFAULT_SHIPPING_STATUS_ID', NULL, '1', '1', NULL, NULL, 6),
('configuration/DELETE_GUEST_ACCOUNT', NULL, 'true', 'true', 'switcher', 7, 5),
	('configuration/DIR_FS_CACHE', NULL, 'cache', 'cache', NULL, 2, 11),
('configuration/DISPLAY_CART', NULL, 'true', 'true', 'switcher', 28, 1),
('configuration/DISPLAY_PAGE_PARSE_TIME', NULL, 'false', 'false', 'switcher', 4, 10),
('configuration/DOWNLOAD_BY_REDIRECT', NULL, 'false', 'false', 'switcher', 2, 13),
('configuration/DOWNLOAD_ENABLED', NULL, 'true', 'true', 'switcher', 1, 13),
('configuration/DOWNLOAD_MIN_ORDERS_STATUS', NULL, '3', '3', 'download-order-status', 5, 13),
('configuration/DOWNLOAD_STOCK_CHECK', NULL, 'true', 'true', 'switcher', 3, 9),
('configuration/DOWNLOAD_UNALLOWED_PAYMENT', NULL, 'banktransfer,cod,invoice,moneyorder',
 'banktransfer,cod,invoice,moneyorder', NULL, 5, 13),
	('configuration/EMAIL_BILLING_ADDRESS', NULL, '', '', NULL, 32, 12),
('configuration/EMAIL_BILLING_FORWARDING_STRING', NULL, '', '', NULL, 37, 12),
('configuration/EMAIL_BILLING_NAME', NULL, 'Ihr Name', 'Ihr Name', NULL, 33, 12),
('configuration/EMAIL_BILLING_REPLY_ADDRESS', NULL, '', '', NULL, 34, 12),
('configuration/EMAIL_BILLING_REPLY_ADDRESS_NAME', NULL, 'Ihr Name', 'Ihr Name', NULL, 35, 12),
('configuration/EMAIL_BILLING_SUBJECT', NULL, 'Verrechnung', 'Verrechnung', NULL, 36, 12),
('configuration/EMAIL_BILLING_SUBJECT_ORDER', NULL, 'Ihre Bestellung {$nr}, am {$date}',
 'Ihre Bestellung {$nr}, am {$date}', NULL, 38, 12),
	('configuration/EMAIL_FROM', NULL, '', '', NULL, 15, 1),
('configuration/EMAIL_LINEFEED', NULL, 'LF', 'LF', 'line-break', 10, 12),
	('configuration/EMAIL_SIGNATURE', NULL, '', '', 'textarea', 16, 12),
	('configuration/EMAIL_SUPPORT_ADDRESS', NULL, '', '', NULL, 26, 12),
('configuration/EMAIL_SUPPORT_FORWARDING_STRING', NULL, '', '', NULL, 31, 12),
('configuration/EMAIL_SUPPORT_NAME', NULL, 'Ihr Name', 'Ihr Name', NULL, 27, 12),
('configuration/EMAIL_SUPPORT_REPLY_ADDRESS', NULL, '', '', NULL, 28, 12),
('configuration/EMAIL_SUPPORT_REPLY_ADDRESS_NAME', NULL, 'Ihr Name', 'Ihr Name', NULL, 29, 12),
('configuration/EMAIL_SUPPORT_SUBJECT', NULL, 'Informationen zu Ihrem Kundenkonto',
 'Informationen zu Ihrem Kundenkonto', NULL, 30, 12),
('configuration/EMAIL_TRANSPORT', NULL, 'mail', 'mail', 'email-transport-method', 1, 12),
('configuration/EMAIL_USE_HTML', NULL, 'true', 'true', 'switcher', 11, 12),
('configuration/ENTRY_CITY_MIN_LENGTH', NULL, '2', '2', 'number', 8, 2),
('configuration/ENTRY_COMPANY_MIN_LENGTH', NULL, '2', '2', 'number', 6, 2),
('configuration/ENTRY_DOB_MIN_LENGTH', NULL, '10', '10', 'number', 3, 2),
('configuration/ENTRY_EMAIL_ADDRESS_CHECK', NULL, 'false', 'false', 'switcher', 12, 12),
('configuration/ENTRY_EMAIL_ADDRESS_MIN_LENGTH', NULL, '6', '6', 'number', 4, 2),
('configuration/ENTRY_FIRST_NAME_MIN_LENGTH', NULL, '2', '2', 'number', 1, 2),
('configuration/ENTRY_LAST_NAME_MIN_LENGTH', NULL, '2', '2', 'number', 2, 2),
('configuration/ENTRY_PASSWORD_MIN_LENGTH', NULL, '5', '5', 'number', 11, 2),
('configuration/ENTRY_POSTCODE_MIN_LENGTH', NULL, '4', '4', 'number', 7, 2),
('configuration/ENTRY_STATE_MIN_LENGTH', NULL, '2', '2', 'number', 9, 2),
('configuration/ENTRY_STREET_ADDRESS_MIN_LENGTH', NULL, '5', '5', 'number', 5, 2),
('configuration/ENTRY_HOUSENUMBER_MIN_LENGTH', NULL, '1', '1', 'number', 5, 2),
('configuration/ENTRY_TELEPHONE_MIN_LENGTH', NULL, '0', '0', 'number', 10, 2),
	('configuration/ERROR_REPORT_EMAIL', NULL, '', '', NULL, 8, 10),
('configuration/EXPECTED_PRODUCTS_FIELD', NULL, 'date_expected', 'date_expected', 'products-order-by', 24, 1),
('configuration/EXPECTED_PRODUCTS_SORT', NULL, 'asc', 'asc', 'ordering', 23, 1),
	('configuration/GAMBIO_SHOP_KEY', NULL, '', '', NULL, 1, 753),
('configuration/GENDER_MANDATORY', NULL, 'false', 'false', 'switcher', 9, 5),
('configuration/GM_SET_OUT_OF_STOCK_ATTRIBUTES', NULL, 'false', 'false', 'switcher', NULL, 9),
('configuration/GM_SET_OUT_OF_STOCK_ATTRIBUTES_SHOW', NULL, 'false', 'false', 'switcher', NULL, 9),
('configuration/GM_SET_OUT_OF_STOCK_PRODUCTS', NULL, 'false', 'false', 'switcher', NULL, 9),
('configuration/GOOGLE_CONVERSION', NULL, 'false', 'false', 'switcher', NULL, 19),
	('configuration/GOOGLE_CONVERSION_ID', NULL, '', '', NULL, 2, 19),
('configuration/GOOGLE_CONVERSION_LABEL', NULL, 'Purchase', 'Purchase', NULL, 4, 19),
	('configuration/GOOGLE_LANG', NULL, 'de', 'de', NULL, 3, 19),
	('configuration/GROUP_CHECK', NULL, 'false', 'false', 'switcher', 9, 17),
('configuration/GZIP_COMPRESSION', NULL, 'true', 'true', 'switcher', 1, 14),
	('configuration/GZIP_LEVEL', NULL, '9', '9', NULL, 2, 14),
('configuration/HTML_COMPRESSION', NULL, 'false', 'false', 'switcher', 5, 14),
('configuration/CSS_INLINE_OUTPUT', NULL, 'false', 'false', 'switcher', 6, 14),
	('configuration/HTTP_CACHING', NULL, 'true', 'true', NULL, 7, 11),
('configuration/IMAGE_MANIPULATOR', NULL, 'image_manipulator_GD2.php', 'image_manipulator_GD2.php', NULL, 3, 4),
	('configuration/IMAGE_QUALITY', NULL, '75', '75', 'number', 2, 4),
('configuration/LOGGING_ENABLED', NULL, 'true', 'true', 'switcher', NULL, 10),
('configuration/LOG_SQL_BACKEND', NULL, 'false', 'false', 'switcher', 6, 10),
('configuration/LOG_SQL_FRONTEND', NULL, 'false', 'false', 'switcher', 5, 10),
('configuration/MAX_ADDRESS_BOOK_ENTRIES', NULL, '5', '5', 'number', 1, 3),
('configuration/MAX_DISPLAY_ALSO_PURCHASED', NULL, '4', '4', 'number', 16, 3),
('configuration/MAX_DISPLAY_ALSO_PURCHASED_DAYS', NULL, '100', '100', 'number', 17, 3),
('configuration/MAX_DISPLAY_BESTSELLERS', NULL, '5', '5', 'number', 15, 3),
('configuration/MAX_DISPLAY_CATEGORIES_PER_ROW', NULL, '2', '2', 'number', 13, 3),
('configuration/MAX_DISPLAY_MANUFACTURERS_IN_A_LIST', NULL, '1', '1', 'number', 7, 3),
('configuration/MAX_DISPLAY_MANUFACTURER_NAME_LEN', NULL, '15', '15', 'number', 8, 3),
('configuration/MAX_DISPLAY_NEW_PRODUCTS_DAYS', NULL, '30', '30', 'number', 22, 3),
('configuration/MAX_DISPLAY_NEW_REVIEWS', NULL, '6', '6', 'number', 9, 3),
('configuration/MAX_DISPLAY_ORDER_HISTORY', NULL, '5', '5', 'number', 19, 3),
('configuration/MAX_DISPLAY_PAGE_LINKS', NULL, '4', '4', 'number', 3, 3),
('configuration/MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX', NULL, '6', '6', 'number', 18, 3),
('configuration/MAX_DISPLAY_PRODUCTS_NEW', NULL, '10', '10', 'number', 14, 3),
('configuration/MAX_DISPLAY_SEARCH_RESULTS', NULL, '8', '8', 'number', 2, 3),
('configuration/MAX_DISPLAY_SPECIAL_PRODUCTS', NULL, '8', '8', 'number', 4, 3),
('configuration/MAX_DISPLAY_UPCOMING_PRODUCTS', NULL, '5', '5', 'number', 6, 3),
('configuration/MAX_MANUFACTURERS_LIST', NULL, '1', '1', 'number', 7, 3),
('configuration/MAX_PRODUCTS_QTY', NULL, '1000000', '1000000', 'number', 21, 3),
('configuration/MAX_RANDOM_SELECT_NEW', NULL, '30', '30', 'number', 11, 3),
('configuration/MAX_RANDOM_SELECT_REVIEWS', NULL, '10', '10', 'number', 10, 3),
('configuration/MAX_RANDOM_SELECT_SPECIALS', NULL, '10', '10', 'number', 12, 3),
('configuration/MIN_DISPLAY_ALSO_PURCHASED', NULL, '1', '1', 'number', 16, 2),
('configuration/MIN_DISPLAY_BESTSELLERS', NULL, '1', '1', 'number', 15, 2),
('configuration/MODULE_BRICKFOX_EXCLUDE_CATEGORIES', NULL, '', '', NULL, 5, 26),
('configuration/MODULE_BRICKFOX_EXCLUDE_PRODUCTS', NULL, '', '', NULL, 6, 26),
('configuration/MODULE_BRICKFOX_PASSWORD', NULL, '', '', NULL, 4, 26),
('configuration/MODULE_BRICKFOX_PORT', NULL, '443', '443', NULL, 2, 26),
('configuration/MODULE_BRICKFOX_STATUS', NULL, 'False', 'False', 'switcher', 7, 26),
	('configuration/MODULE_BRICKFOX_URL', NULL, '', '', NULL, 1, 26),
('configuration/MODULE_BRICKFOX_USERNAME', NULL, '', '', NULL, 3, 26),
('configuration/MODULE_DELISPRINT_FILE', NULL, 'delisprint.txt', 'delisprint.txt', NULL, 1, 6),
('configuration/MODULE_DELISPRINT_STATUS', NULL, 'True', 'True', 'switcher', 1, 6),
('configuration/MODULE_EXPORT_INSTALLED', NULL, 'magnalister.php', 'magnalister.php', NULL, NULL, 6),
('configuration/MODULE_GLS_FILE', NULL, 'gls.txt', 'gls.txt', NULL, 1, 6),
('configuration/MODULE_GLS_STATUS', NULL, 'True', 'True', 'switcher', 1, 6),
('configuration/MODULE_HERMES_FILE', NULL, 'hermes.txt', 'hermes.txt', NULL, 1, 6),
('configuration/MODULE_HERMES_STATUS', NULL, 'True', 'True', 'switcher', 1, 6),
('configuration/MODULE_ORDER_TOTAL_COD_FEE_RULES', NULL,
 'free|AT:3.00,DE:3.58,00:9.99|flat|AT:3.00,DE:3.58,00:9.99|item|AT:3.00,DE:3.58,00:9.99|table|AT:3.00,DE:3.58,00:9.99|zones|CA:4.50,US:3.00,00:9.99|upse|AT:3.00,DE:3.58,00:9.99|chronopost|FR:4.00,00:9.99|dhl|AT:3.00,DE:3.58,00:9.99|ups|AT:3.00,DE:3.58,00:9.99|chp|CH:4.00,00:9.99|dpd|DE:4.00,00:9.99|ap|AT:3.63,00:9.99|zonese|DE:4.00,00:9.99|selfpickup|DE:4.00,00:9.99|gambioultra|DE:4.00,00:9.99|fedexeu|DE:4.00,00:9.99|dp|DE:4.00,00:9.99',
 'free|AT:3.00,DE:3.58,00:9.99|flat|AT:3.00,DE:3.58,00:9.99|item|AT:3.00,DE:3.58,00:9.99|table|AT:3.00,DE:3.58,00:9.99|zones|CA:4.50,US:3.00,00:9.99|upse|AT:3.00,DE:3.58,00:9.99|chronopost|FR:4.00,00:9.99|dhl|AT:3.00,DE:3.58,00:9.99|ups|AT:3.00,DE:3.58,00:9.99|chp|CH:4.00,00:9.99|dpd|DE:4.00,00:9.99|ap|AT:3.63,00:9.99|zonese|DE:4.00,00:9.99|selfpickup|DE:4.00,00:9.99|gambioultra|DE:4.00,00:9.99|fedexeu|DE:4.00,00:9.99|dp|DE:4.00,00:9.99',
 'cod-fee', NULL, 6),
('configuration/MODULE_ORDER_TOTAL_COD_FEE_SORT_ORDER', NULL, '35', '35', NULL, NULL, 6),
('configuration/MODULE_ORDER_TOTAL_COD_FEE_STATUS', NULL, 'true', 'true', 'switcher', NULL, 6),
('configuration/MODULE_ORDER_TOTAL_COD_FEE_TAX_CLASS', NULL, '0', '0', 'tax-class', NULL, 6),
('configuration/MODULE_ORDER_TOTAL_COD_FEE_TRANSFER_CHARGE', 'cod-fee',
 'ap|00:0|chp|00:0|chronopost|00:0|dhl|00:0|dp|00:0|dpd|00:0|fedexeu|00:0|flat|00:0|free|00:0|freeamount|00:0|gambioultra|00:0|item|00:0|selfpickup|00:0|table|00:0|ups|00:0|upse|00:0|zones|00:0|zonese|00:0',
 'ap|00:0|chp|00:0|chronopost|00:0|dhl|00:0|dp|00:0|dpd|00:0|fedexeu|00:0|flat|00:0|free|00:0|freeamount|00:0|gambioultra|00:0|item|00:0|selfpickup|00:0|table|00:0|ups|00:0|upse|00:0|zones|00:0|zonese|00:0',
 'cod-fee', NULL, 6),
('configuration/MODULE_ORDER_TOTAL_COUPON_CALC_TAX', NULL, 'Standard', 'Standard', 'tax-calculation-mode', 7, 6),
('configuration/MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING', NULL, 'false', 'false', 'switcher', 5, 6),
('configuration/MODULE_ORDER_TOTAL_COUPON_INC_TAX', NULL, 'true', 'true', 'switcher', 6, 6),
('configuration/MODULE_ORDER_TOTAL_COUPON_SHOW_INFO', NULL, 'false', 'false', 'switcher', 9, 6),
('configuration/MODULE_ORDER_TOTAL_COUPON_SORT_ORDER', NULL, '70', '70', NULL, 2, 6),
('configuration/MODULE_ORDER_TOTAL_COUPON_STATUS', NULL, 'true', 'true', 'switcher', 1, 6),
('configuration/MODULE_ORDER_TOTAL_COUPON_TAX_CLASS', NULL, '0', '0', 'tax-class', NULL, 6),
('configuration/MODULE_ORDER_TOTAL_DISCOUNT_SORT_ORDER', NULL, '20', '20', NULL, 2, 6),
('configuration/MODULE_ORDER_TOTAL_DISCOUNT_STATUS', NULL, 'true', 'true', 'switcher', 1, 6),
('configuration/MODULE_ORDER_TOTAL_FREEAMOUNT_FREE', NULL, 'AT:3.00,DE:3.58,00:9.99', 'AT:3.00,DE:3.58,00:9.99',
 NULL, NULL, 6),
('configuration/MODULE_ORDER_TOTAL_GV_CALC_TAX', NULL, 'None', 'None', 'tax-calculation-mode', 7, 6),
('configuration/MODULE_ORDER_TOTAL_GV_CREDIT_TAX', NULL, 'false', 'false', 'switcher', 8, 6),
('configuration/MODULE_ORDER_TOTAL_GV_INC_SHIPPING', NULL, 'False', 'False', 'switcher', 5, 6),
('configuration/MODULE_ORDER_TOTAL_GV_INC_TAX', NULL, 'true', 'true', 'switcher', 6, 6),
('configuration/MODULE_ORDER_TOTAL_GV_QUEUE', NULL, 'true', 'true', 'switcher', 3, 6),
('configuration/MODULE_ORDER_TOTAL_GV_SHOW_INFO', NULL, 'false', 'false', 'switcher', 9, 6),
('configuration/MODULE_ORDER_TOTAL_GV_SORT_ORDER', NULL, '80', '80', NULL, 2, 6),
('configuration/MODULE_ORDER_TOTAL_GV_STATUS', NULL, 'true', 'true', 'switcher', 1, 6),
('configuration/MODULE_ORDER_TOTAL_GV_TAX_CLASS', NULL, '0', '0', 'tax-class', NULL, 6),
('configuration/MODULE_ORDER_TOTAL_INSTALLED', NULL,
 'ot_subtotal.php;ot_discount.php;ot_coupon.php;ot_shipping.php;ot_cod_fee.php;ot_gv.php;ot_subtotal_no_tax.php;ot_tax.php;ot_total_netto.php;ot_total.php',
 'ot_subtotal.php;ot_discount.php;ot_coupon.php;ot_shipping.php;ot_cod_fee.php;ot_gv.php;ot_subtotal_no_tax.php;ot_tax.php;ot_total_netto.php;ot_total.php',
 NULL, NULL, 6),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', NULL, 'national', 'national', 'shipping-destination', 5, 6),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', NULL, 'false', 'false', 'switcher', 3, 6),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', NULL, '50', '50', NULL, 4, 6),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', NULL, '30', '30', NULL, 2, 6),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_STATUS', NULL, 'true', 'true', 'switcher', 1, 6),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_TAX_CLASS', NULL, '0', '0', 'tax-class', 7, 6),
('configuration/MODULE_ORDER_TOTAL_SHIPPING_SHOW_TITLE', NULL, 'true', 'true', 'switcher', 8, 6),
('configuration/MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_SORT_ORDER', NULL, '96', '96', NULL, 2, 6),
('configuration/MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_STATUS', NULL, 'true', 'true', 'switcher', 1, 6),
('configuration/MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', NULL, '10', '10', NULL, 2, 6),
('configuration/MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', NULL, 'true', 'true', 'switcher', 1, 6),
('configuration/MODULE_ORDER_TOTAL_TAX_SORT_ORDER', NULL, '97', '97', NULL, 2, 6),
('configuration/MODULE_ORDER_TOTAL_TAX_STATUS', NULL, 'true', 'true', 'switcher', 1, 6),
('configuration/MODULE_ORDER_TOTAL_TOTAL_NETTO_SORT_ORDER', NULL, '98', '98', NULL, 2, 6),
('configuration/MODULE_ORDER_TOTAL_TOTAL_NETTO_STATUS', NULL, 'false', 'false', 'switcher', 1, 6),
('configuration/MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', NULL, '99', '99', NULL, 2, 6),
('configuration/MODULE_ORDER_TOTAL_TOTAL_STATUS', NULL, 'true', 'true', 'switcher', 1, 6),
('configuration/MODULE_PAYMENT_SEPA_COMPANY', NULL, '', '', NULL, NULL, 6),
('configuration/MODULE_PAYMENT_SEPA_CREDITOR_ID', NULL, '', '', NULL, NULL, 6),
('configuration/MODULE_PAYMENT_SEPA_POSTCODE_CITY', NULL, '', '', NULL, NULL, 6),
('configuration/MODULE_PAYMENT_SEPA_SEND_MANDATE', NULL, 'true', 'true', NULL, NULL, 6),
('configuration/MODULE_PAYMENT_SEPA_STREET_ADDRESS', NULL, '', '', NULL, NULL, 6),
('configuration/MODULE_SHIPPING_INSTALLED', NULL, '', '', NULL, NULL, 6),
('configuration/MODULE_PAYMENT_INSTALLED', NULL, '', '', NULL, NULL, 6),
	('configuration/MO_PICS', NULL, '1000', '1000', 'number', 3, 4),
('configuration/NEW_SIGNUP_DISCOUNT_COUPON', NULL, '', '', NULL, 5, 0),
('configuration/NEW_SIGNUP_GIFT_VOUCHER_AMOUNT', NULL, '', '', NULL, 4, 0),
('configuration/PAYPAL_API_KEY', NULL,
 '120,116,99,111,109,109,101,114,99,101,95,83,104,111,112,112,105,110,103,67,97,114,116,95',
 '120,116,99,111,109,109,101,114,99,101,95,83,104,111,112,112,105,110,103,67,97,114,116,95', NULL, 5, 6),
	('configuration/PAYPAL_API_PWD', NULL, '', '', NULL, 5, 25),
('configuration/PAYPAL_API_SANDBOX_PWD', NULL, '', '', NULL, 5, 25),
('configuration/PAYPAL_API_SANDBOX_SIGNATURE', NULL, '', '', NULL, 6, 25),
('configuration/PAYPAL_API_SANDBOX_USER', NULL, '', '', NULL, 4, 25),
	('configuration/PAYPAL_API_SIGNATURE', NULL, '', '', NULL, 6, 25),
	('configuration/PAYPAL_API_USER', NULL, '', '', NULL, 4, 25),
('configuration/PAYPAL_COUNTRY_MODE', NULL, 'de', 'de', NULL, 16, 25),
('configuration/PAYPAL_EXPRESS_ADDRESS_CHANGE', NULL, 'true', 'true', NULL, 17, 25),
('configuration/PAYPAL_EXPRESS_ADDRESS_OVERRIDE', NULL, 'true', 'true', NULL, 18, 25),
('configuration/PAYPAL_EXPRESS_PAYMENTACTION', NULL, 'Sale', 'Sale', NULL, 16, 25),
	('configuration/PAYPAL_MODE', NULL, 'live', 'live', NULL, 1, 25),
('configuration/PAYPAL_ORDER_STATUS_PENDING_ID', NULL, '1', '1', NULL, 11, 25),
('configuration/PAYPAL_ORDER_STATUS_REJECTED_ID', NULL, '1', '1', NULL, 12, 25),
('configuration/PAYPAL_ORDER_STATUS_SUCCESS_ID', NULL, '2', '2', NULL, 10, 25),
('configuration/PAYPAL_ORDER_STATUS_TMP_ID', NULL, '1', '1', NULL, 9, 25),
	('configuration/PAYPAL_SHOP_LOGO', NULL, '', '', NULL, 13, 25),
('configuration/PREFER_GZHANDLER', NULL, 'false', 'false', 'switcher', 3, 14),
('configuration/PRICE_IS_BRUTTO', NULL, 'true', 'true', 'switcher', 42, 1),
	('configuration/PRICE_PRECISION', NULL, '4', '4', NULL, 43, 1),
('configuration/PRODUCT_IMAGE_INFO_BEVEL', NULL, '', '', NULL, 21, 4),
('configuration/PRODUCT_IMAGE_INFO_DROP_SHADDOW', NULL, '', '', NULL, 27, 4),
('configuration/PRODUCT_IMAGE_INFO_ELLIPSE', NULL, '', '', NULL, 23, 4),
('configuration/PRODUCT_IMAGE_INFO_FRAME', NULL, '', '', NULL, 26, 4),
('configuration/PRODUCT_IMAGE_INFO_GREYSCALE', NULL, '', '', NULL, 22, 4),
('configuration/PRODUCT_IMAGE_INFO_HEIGHT', NULL, '350', '350', 'number', 10, 4),
('configuration/PRODUCT_IMAGE_INFO_MERGE', NULL, '', '', NULL, 25, 4),
('configuration/PRODUCT_IMAGE_INFO_MOTION_BLUR', NULL, '', '', NULL, 28, 4),
('configuration/PRODUCT_IMAGE_INFO_ROUND_EDGES', NULL, '', '', NULL, 24, 4),
('configuration/PRODUCT_IMAGE_INFO_WIDTH', NULL, '369', '369', 'number', 9, 4),
('configuration/PRODUCT_IMAGE_POPUP_BEVEL', NULL, '', '', NULL, 29, 4),
('configuration/PRODUCT_IMAGE_POPUP_DROP_SHADDOW', NULL, '', '', NULL, 35, 4),
('configuration/PRODUCT_IMAGE_POPUP_ELLIPSE', NULL, '', '', NULL, 31, 4),
('configuration/PRODUCT_IMAGE_POPUP_FRAME', NULL, '', '', NULL, 34, 4),
('configuration/PRODUCT_IMAGE_POPUP_GREYSCALE', NULL, '', '', NULL, 30, 4),
('configuration/PRODUCT_IMAGE_POPUP_HEIGHT', NULL, '600', '600', 'number', 12, 4),
('configuration/PRODUCT_IMAGE_POPUP_MERGE', NULL, '', '', NULL, 33, 4),
('configuration/PRODUCT_IMAGE_POPUP_MOTION_BLUR', NULL, '', '', NULL, 36, 4),
('configuration/PRODUCT_IMAGE_POPUP_ROUND_EDGES', NULL, '', '', NULL, 32, 4),
('configuration/PRODUCT_IMAGE_POPUP_WIDTH', NULL, '600', '600', 'number', 11, 4),
('configuration/PRODUCT_IMAGE_THUMBNAIL_BEVEL', NULL, '', '', NULL, 13, 4),
('configuration/PRODUCT_IMAGE_THUMBNAIL_DROP_SHADDOW', NULL, '', '', NULL, 19, 4),
('configuration/PRODUCT_IMAGE_THUMBNAIL_ELLIPSE', NULL, '', '', NULL, 15, 4),
('configuration/PRODUCT_IMAGE_THUMBNAIL_FRAME', NULL, '', '', NULL, 18, 4),
('configuration/PRODUCT_IMAGE_THUMBNAIL_GREYSCALE', NULL, '', '', NULL, 14, 4),
('configuration/PRODUCT_IMAGE_THUMBNAIL_HEIGHT', NULL, '130', '130', 'number', 8, 4),
('configuration/PRODUCT_IMAGE_THUMBNAIL_MERGE', NULL, '', '', NULL, 17, 4),
('configuration/PRODUCT_IMAGE_THUMBNAIL_MOTION_BLUR', NULL, '', '', NULL, 20, 4),
('configuration/PRODUCT_IMAGE_THUMBNAIL_ROUND_EDGES', NULL, '', '', NULL, 16, 4),
('configuration/PRODUCT_IMAGE_THUMBNAIL_WIDTH', NULL, '150', '150', 'number', 7, 4),
	('configuration/PRODUCT_LIST_FILTER', NULL, '1', '1', NULL, 52, 1),
('configuration/PRODUCT_REVIEWS_VIEW', NULL, '5', '5', 'number', 20, 3),
('configuration/QUICKLINK_ACTIVATED', NULL, 'true', 'true', 'switcher', 11, 17),
('configuration/REVIEW_TEXT_MIN_LENGTH', NULL, '50', '50', 'number', 14, 2),
('configuration/SEARCH_IN_ATTR', NULL, 'false', 'false', 'switcher', 50, 1),
('configuration/SEARCH_IN_DESC', NULL, 'true', 'true', 'switcher', 51, 1),
('configuration/SECURITY_CODE_LENGTH', NULL, '10', '10', 'switcher', 3, 0),
('configuration/SENDMAIL_PATH', NULL, '/usr/sbin/sendmail', '/usr/sbin/sendmail', NULL, 2, 12),
('configuration/SEND_EMAILS', NULL, 'true', 'true', 'switcher', 13, 12),
('configuration/SEND_EMAIL_BY_BILLING_ADRESS', NULL, 'SHOP_OWNER', 'SHOP_OWNER', 'sender-mail', 40, 12),
('configuration/SESSION_CHECK_IP_ADDRESS', NULL, 'False', 'False', 'switcher', 5, 15),
('configuration/SESSION_CHECK_USER_AGENT', NULL, 'False', 'False', 'switcher', 4, 15),
('configuration/SESSION_FORCE_COOKIE_USE', NULL, 'False', 'False', 'switcher', 2, 15),
('configuration/SESSION_RECREATE', NULL, 'True', 'True', 'switcher', 7, 15),
	('configuration/SESSION_TIMEOUT', NULL, '24', '24', NULL, 8, 15),
	('configuration/SHIPPING_BOX_PADDING', NULL, '0', '0', NULL, 5, 7),
	('configuration/SHIPPING_BOX_WEIGHT', NULL, '0', '0', NULL, 4, 7),
('configuration/SHIPPING_INFOS', NULL, '3889891', '3889891', NULL, 5, 7),
('configuration/SHIPPING_MAX_WEIGHT', NULL, '50', '50', NULL, 3, 7),
('configuration/SHIPPING_ORIGIN_COUNTRY', NULL, '81', '81', 'country', 1, 7),
('configuration/SHIPPING_ORIGIN_ZIP', NULL, '12345', '12345', NULL, 2, 7),
('configuration/SHOW_CART_SHIPPING_COSTS', NULL, 'true', 'true', 'switcher', 8, 7),
('configuration/SHOW_CART_SHIPPING_WEIGHT', NULL, 'true', 'true', 'switcher', 9, 7),
('configuration/SHOW_COUNTS', NULL, 'false', 'false', 'switcher', 32, 1),
('configuration/SHOW_SHIPPING', NULL, 'true', 'true', 'switcher', 6, 7),
('configuration/SHOW_UNTRANSLATED_MENUITEMS', NULL, 'false', 'false', 'switcher', 13, 17),
('configuration/SMTP_AUTH', NULL, 'false', 'false', 'switcher', 8, 12),
('configuration/SMTP_Backup_Server', NULL, 'localhost', 'localhost', NULL, 4, 12),
('configuration/SMTP_ENCRYPTION', NULL, 'none', 'none', 'smtp-encryption', 9, 12),
('configuration/SMTP_MAIN_SERVER', NULL, 'localhost', 'localhost', NULL, 3, 12),
('configuration/SMTP_PASSWORD', NULL, 'Please Enter', 'Please Enter', NULL, 7, 12),
	('configuration/SMTP_PORT', NULL, '25', '25', NULL, 5, 12),
('configuration/SMTP_USERNAME', NULL, 'Please Enter', 'Please Enter', NULL, 6, 12),
('configuration/SQL_LOG_MAX_FILESIZE', NULL, '1', '1', NULL, 7, 10),
('configuration/STOCK_ALLOW_CHECKOUT', NULL, 'true', 'true', 'switcher', 5, 9),
('configuration/STOCK_CHECK', NULL, 'true', 'true', 'switcher', 1, 9),
('configuration/STOCK_LIMITED', NULL, 'true', 'true', 'switcher', 4, 9),
('configuration/STOCK_MARK_PRODUCT_OUT_OF_STOCK', NULL, '***', '***', NULL, 6, 9),
	('configuration/STOCK_REORDER_LEVEL', NULL, '5', '5', NULL, 7, 9),
('configuration/CHECK_STOCK_BEFORE_SHOPPING_CART', NULL, 'false', 'false', 'switcher', 8, 9),
('configuration/STORE_COUNTRY', NULL, '81', '81', 'country', 10, 1),
('configuration/STORE_DB_TRANSACTIONS', NULL, 'false', 'false', 'switcher', 8, 10),
('configuration/STORE_NAME', NULL, 'Shopname', 'Shopname', NULL, 1, 1),
('configuration/STORE_NAME_ADDRESS', NULL, '', '', 'textarea', 17, 1),
('configuration/STORE_OWNER', NULL, 'Shopbetreiber', 'Shopbetreiber', NULL, 2, 1),
('configuration/STORE_OWNER_EMAIL_ADDRESS', NULL, '', '', NULL, 14, 1),
('configuration/STORE_PAGE_PARSE_TIME', NULL, 'false', 'false', 'switcher', 1, 10),
('configuration/STORE_PAGE_PARSE_TIME_LOG', NULL, '/tmp/', '/tmp/', NULL, 2, 10),
('configuration/STORE_ZONE', NULL, '88', '88', 'country-zone', 11, 1),
	('configuration/TRADER_FAX', NULL, '', '', NULL, 13, 1),
	('configuration/TRADER_FIRSTNAME', NULL, '', '', NULL, 4, 1),
	('configuration/TRADER_LOCATION', NULL, '', '', NULL, 9, 1),
	('configuration/TRADER_NAME', NULL, '', '', NULL, 5, 1),
	('configuration/TRADER_STREET', NULL, '', '', NULL, 6, 1),
	('configuration/TRADER_STREET_NUMBER', NULL, '', '', NULL, 7, 1),
	('configuration/TRADER_TEL', NULL, '', '', NULL, 12, 1),
	('configuration/TRADER_ZIPCODE', NULL, '', '', NULL, 8, 1),
('configuration/UNFOLD_FAVS_BOX', NULL, 'false', 'false', 'switcher', 48, 1),
	('configuration/USE_CACHE', NULL, 'false', 'false', NULL, 1, 11),
('configuration/USE_DEFAULT_LANGUAGE_CURRENCY', NULL, 'false', 'false', 'switcher', 25, 1),
	('configuration/USE_WYSIWYG', NULL, 'true', 'true', 'switcher', 1, 17),
('configuration/_PAYMENT_SKRILL_CANCELED_STATUS_ID', NULL, '0', '0', NULL, 8, 32),
('configuration/_PAYMENT_SKRILL_EMAILID', NULL, '', '', NULL, 1, 32),
('configuration/_PAYMENT_SKRILL_EXPERTMODE', NULL, '0', '0', NULL, 9, 32),
('configuration/_PAYMENT_SKRILL_MERCHANTID', NULL, '', '', NULL, 3, 32),
('configuration/_PAYMENT_SKRILL_MODULES', NULL, '', '', NULL, 4, 32),
('configuration/_PAYMENT_SKRILL_PENDING_STATUS_ID', NULL, '0', '0', NULL, 7, 32),
('configuration/_PAYMENT_SKRILL_PROCESSED_STATUS_ID', NULL, '0', '0', NULL, 6, 32),
	('configuration/_PAYMENT_SKRILL_PWD', NULL, '', '', NULL, 2, 32),
('configuration/_PAYMENT_SKRILL_TMP_STATUS_ID', NULL, '0', '0', NULL, 5, 32),
('configuration/EMAIL_MAX_LIMIT', NULL, '1000', '1000', NULL, 99, 12),
('configuration/MODULE_PAYMENT_AMAZONADVPAY_ALIAS', NULL, 'AMAZ', 'AMAZ', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_BILLSAFE_3_INSTALLMENT_ALIAS', NULL, 'BSRA', 'BSRA', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_BILLSAFE_3_INVOICE_ALIAS', NULL, 'BSRE', 'BSRE', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_CASH_ALIAS', NULL, 'BAR', 'BAR', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_EUSTANDARDTRANSFER_ALIAS', NULL, 'EUS', 'EUS', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_BANKTRANSFER_ALIAS', NULL, 'LS', 'LS', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SEPA_ALIAS', NULL, 'SEPA', 'SEPA', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_COD_ALIAS', NULL, 'NN', 'NN', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_INVOICE_ALIAS', NULL, 'RECH', 'RECH', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_MONEYORDER_ALIAS', NULL, 'VK', 'VK', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_PAYPAL3_ALIAS', NULL, 'PP', 'PP', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_HPCC_ALIAS', NULL, 'HPCC', 'HPCC', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_HPDC_ALIAS', NULL, 'HPDC', 'HPDC', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_HPDD_ALIAS', NULL, 'HPDD', 'HPDD', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_HPGP_ALIAS', NULL, 'HPGP', 'HPGP', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_HPIDL_ALIAS', NULL, 'HPID', 'HPID', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_HPPP_ALIAS', NULL, 'HPVK', 'HPVK', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_HPPAY_ALIAS', NULL, 'HPPP', 'HPPP', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_HPSU_ALIAS', NULL, 'HPSU', 'HPSU', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_HPBS_ALIAS', NULL, 'HPBS', 'HPBS', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_HPIV_ALIAS', NULL, 'HPIV', 'HPIV', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_HPPF_ALIAS', NULL, 'HPPF', 'HPPF', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_HPMK_ALIAS', NULL, 'HPMK', 'HPMK', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_KLARNA_INVOICE_ALIAS', NULL, 'KLRE', 'KLRE', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_KLARNA_PARTPAY_ALIAS', NULL, 'KLRA', 'KLRA', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_IPAYMENT_CC_ALIAS', NULL, 'IPCC', 'IPCC', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_IPAYMENT_ELV_ALIAS', NULL, 'IPEL', 'IPEL', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_ANZAHLUNGSKAUF_ALIAS', NULL, 'MAAN', 'MAAN', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_CONFIG_ALIAS', NULL, 'MACO', 'MACO', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_CREDIT_CARD_ALIAS', NULL, 'MACC', 'MACC', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_DEBIT_CARD_ALIAS', NULL, 'MADC', 'MADC', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_ELV_ALIAS', NULL, 'MAEL', 'MAEL', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_FINANZIERUNG_ALIAS', NULL, 'MAFI', 'MAFI', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_PHONE_ALIAS', NULL, 'MAPH', 'MAPH', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_RATENZAHLUNG_ALIAS', NULL, 'MARA', 'MARA', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_RECHNUNGSKAUF_ALIAS', NULL, 'MARE', 'MARE', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_MASTERPAYMENT_SOFORTBANKING_ALIAS', NULL, 'MASO', 'MASO', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SHOPGATE_ALIAS', NULL, 'SHG', 'SHG', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_CC_ALIAS', NULL, 'SKCC', 'SKCC', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_CGB_ALIAS', NULL, 'SKCB', 'SKCB', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_CSI_ALIAS', NULL, 'SKCS', 'SKCS', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_ELV_ALIAS', NULL, 'SKEL', 'SKEL', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_GIROPAY_ALIAS', NULL, 'SKGP', 'SKGP', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_IDEAL_ALIAS', NULL, 'SKID', 'SKID', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_MAE_ALIAS', NULL, 'SKMA', 'SKMA', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_NETPAY_ALIAS', NULL, 'SKNE', 'SKNE', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_PSP_ALIAS', NULL, 'SKPP', 'SKPP', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_PWY_ALIAS', NULL, 'SKPR', 'SKPR', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_SFT_ALIAS', NULL, 'SKSU', 'SKSU', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_WLT_ALIAS', NULL, 'SKEW', 'SKEW', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_PAYINV_ALIAS', NULL, 'SKRE', 'SKRE', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SKRILL_PAYINS_ALIAS', NULL, 'SKRA', 'SKRA', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_PAYONE_CC_ALIAS', NULL, 'PACC', 'PACC', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_PAYONE_ELV_ALIAS', NULL, 'PAEL', 'PAEL', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_PAYONE_COD_ALIAS', NULL, 'PANN', 'PANN', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_PAYONE_OTRANS_ALIAS', NULL, 'PAUW', 'PAUW', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_PAYONE_WLT_ALIAS', NULL, 'PAPP', 'PAPP', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_PAYONE_INSTALLMENT_ALIAS', NULL, 'PARA', 'PARA', NULL, NULL, 0),
('configuration/MODULE_PAYONE_INVOICE_ALIAS', NULL, 'PARE', 'PARE', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_PAYONE_PREPAY_ALIAS', NULL, 'PAVK', 'PAVK', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_PAYGATE_SSL_ALIAS', NULL, 'PAYG', 'PAYG', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_POSTFINANCEAG_BASIC_ALIAS', NULL, 'POFI', 'POFI', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_POSTFINANCEAG_DINERS_ALIAS', NULL, 'PODI', 'PODI', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_POSTFINANCEAG_MASTERCARD_ALIAS', NULL, 'POMA', 'POMA', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_POSTFINANCEAG_AMEX_ALIAS', NULL, 'POAM', 'POAM', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_POSTFINANCEAG_VISA_ALIAS', NULL, 'POVI', 'POVI', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_RSMARTSEPA_ALIAS', NULL, 'RSMA', 'RSMA', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SAFERPAYGW_ALIAS', NULL, 'SAPA', 'SAPA', NULL, NULL, 0),
('configuration/MODULE_PAYMENT_SOFORT_SOFORTUEBERWEISUNG_ALIAS', NULL, 'SÜ', 'SÜ', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_GAMBIOULTRA_ALIAS', NULL, 'ARTV', 'ARTV', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_CHRONOPOST_ALIAS', NULL, 'CHRO', 'CHRO', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_DP_ALIAS', NULL, 'Deutsche Post', 'DHL', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_DHL_ALIAS', NULL, 'DHLA', 'DHLA', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_DPD_ALIAS', NULL, 'DPD', 'DPD', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_FEDEXEU_ALIAS', NULL, 'FED', 'FED', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_HERMESPROPS_ALIAS', NULL, 'HERM', 'HERM', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_INTERKURIER_ALIAS', NULL, 'INT', 'INT', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_AP_ALIAS', NULL, 'ATP', 'ATP', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_FLAT_ALIAS', NULL, 'PAU', 'PAU', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_CHP_ALIAS', NULL, 'CHP', 'CHP', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_SELFPICKUP_ALIAS', NULL, 'ABH', 'ABH', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_UPSE_ALIAS', NULL, 'UPSE', 'UPSE', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_UPS_ALIAS', NULL, 'UPS', 'UPS', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_ZONES_ALIAS', NULL, 'UNV', 'UNV', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_B2CZONES_ALIAS', NULL, 'VER', 'VER', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_TABLE_ALIAS', NULL, 'VKPG', 'VKPG', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_ITEM_ALIAS', NULL, 'VKST', 'VKST', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_FREEAMOUNT_ALIAS', NULL, 'FREI', 'FREI', NULL, NULL, 0),
('configuration/MODULE_SHIPPING_ZONESE_ALIAS', NULL, 'VERS', 'VERS', NULL, NULL, 0),
('configuration/MOVE_ONLY_IF_NO_GUEST', NULL, 'true', 'true', 'switcher', 4, 18),
('configuration/CURRENT_THEME', NULL, 'Malibu', 'Malibu', NULL, 42, 0),
	('configuration/STORE_OWNER_VAT_ID', NULL, '', '', NULL, 3, 18),
('configuration/MAX_DISPLAY_CROSSSELLING', NULL, '4', '4', 'number', 16, 3),
('configuration/USE_BUSTFILES', NULL, 'false', 'false', 'switcher', 5, 14);

INSERT INTO `gx_configurations` (`key`, `language_id`, `value`, `default`, `type`, `sort_order`,
                                 `legacy_group_id`)
VALUES ('gm_configuration/ATTACH_CONDITIONS_OF_USE_IN_ORDER_CONFIRMATION', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/ATTACH_PRIVACY_NOTICE_IN_ORDER_CONFIRMATION', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/ATTACH_WITHDRAWAL_FORM_IN_ORDER_CONFIRMATION', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/ATTACH_WITHDRAWAL_INFO_IN_ORDER_CONFIRMATION', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/CAT_MENU_CLASSIC', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/CAT_MENU_LEFT', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/CAT_MENU_TOP', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/CATEGORY_ACCORDION_EFFECT', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/CATEGORY_DISPLAY_SHOW_ALL_LINK', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/CATEGORY_UNFOLD_LEVEL', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/CATEGORY_TOP_SHOW_LEVEL', NULL, '2', '2', NULL, NULL, NULL),
('gm_configuration/CUSTOMIZER_POSITION', NULL, '1', '1', NULL, NULL, NULL),
	('gm_configuration/DISPLAY_TAX', NULL, '1', '1', NULL, NULL, NULL),
	('gm_configuration/EKOMI_API_ID', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/EKOMI_API_PASSWORD', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/EKOMI_STATUS', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/EKOMI_WIDGET_CODE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/ENABLE_RATING', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/FEATURE_DISPLAY_MODE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/FEATURE_EMPTY_BOX_MODE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/FEATURE_MODE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GLOBAL_FILTER', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_ANALYTICS_CODE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_ANALYTICS_CODE_USE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_AUTO_SHIPPING_STATUS', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_CALLBACK_SERVICE_VVCODE', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_CAPTCHA_TYPE', NULL, 'standard', 'standard', NULL, NULL, NULL),
('gm_configuration/GM_CART_ON_TOP', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_CAT_HOVER', NULL, '#b3ccdd', '#b3ccdd', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_CONDITIONS', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_PRIVACY_ACCOUNT_ADDRESS_BOOK', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_PRIVACY_ACCOUNT_CONTACT', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_PRIVACY_ACCOUNT_NEWSLETTER', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_PRIVACY_CALLBACK', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_PRIVACY_CHECKOUT_PAYMENT', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_PRIVACY_CHECKOUT_SHIPPING', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_PRIVACY_CONTACT', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_PRIVACY_FOUND_CHEAPER', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_PRIVACY_ORDER', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_PRIVACY_REVIEWS', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_PRIVACY_TELL_A_FRIEND', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_CHECK_WITHDRAWAL', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_COOKIE_STATUS', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/GM_COOKIE_POSITION', NULL, 'top', 'top', NULL, NULL, NULL),
('gm_configuration/GM_COOKIE_COLOR', NULL, '#ffffff', '#ffffff', NULL, NULL, NULL),
('gm_configuration/GM_COOKIE_TRANSPARENCY', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_COOKIE_CLOSE_ICON', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/GM_COOKIE_BUTTON_TEXT_COLOR', NULL, '#ffffff', '#ffffff', NULL, NULL, NULL),
('gm_configuration/GM_COOKIE_BUTTON_COLOR', NULL, '#002337', '#002337', NULL, NULL, NULL),
('gm_configuration/GM_CONFIRM_IP', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_CONTACT_VVCODE', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_COUNTER_IP_BARRIER', NULL, '86400', '86400', NULL, NULL, NULL),
('gm_configuration/GM_FORGOT_PASSWORD_VVCODE', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_GAMBIO_CORNER', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_AUTO_WIDTH', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_DURATION', NULL, '10', '10', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_HEIGHT', NULL, '200', '200', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_LIGHTBOX', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_LIGHTBOX_HEIGHT', NULL, '400', '400', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_LIGHTBOX_WIDTH', NULL, '700', '700', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_LIGHTBOX_ZOOM_FROM', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_LIGHTBOX_ZOOM_TO', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_POSITION', NULL, '3', '3', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_POSITION_FROM', NULL, '0% 50%', '0% 50%', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_POSITION_TO', NULL, '100% 50%', '100% 50%', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_WIDTH', NULL, '351', '351', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_ZOOM_FROM', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_GMOTION_STANDARD_ZOOM_TO', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_GPRINT_ALLOWED_FILE_EXTENSIONS', NULL, 'jpg,png,gif,jpeg', 'jpg,png,gif,jpeg', NULL, NULL,
 NULL),
('gm_configuration/GM_GPRINT_AUTO_WIDTH', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_GPRINT_CHARACTER_LENGTH', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_GPRINT_EXCLUDE_SPACES', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_GPRINT_SHOW_TABS', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_GPRINT_UPLOADS_PER_IP', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_GPRINT_UPLOADS_PER_IP_INTERVAL', NULL, '60', '60', NULL, NULL, NULL),
('gm_configuration/GM_HIDE_ATTR_OUT_OF_STOCK', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_INVOICE_ID', NULL, 'R_{INVOICE_ID}_2020', 'R_{INVOICE_ID}_2020', NULL, NULL, NULL),
('gm_configuration/GM_LIGHTBOX_CART', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/GM_LIGHTBOX_CHECKOUT', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/GM_LIGHTBOX_CREATE_ACCOUNT', NULL, 'false', 'false', NULL, NULL, NULL),
	('gm_configuration/GM_LOG_IP', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_LOGIN_TIMELINE', NULL, '20', '20', NULL, NULL, NULL),
('gm_configuration/GM_LOGIN_TIMEOUT', NULL, '20', '20', NULL, NULL, NULL),
('gm_configuration/GM_LOGIN_TRYOUT', NULL, '2', '2', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_CAT', NULL, 'item_ltr.gif', 'item_ltr.gif', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_CAT_SIZE_H', NULL, '13', '13', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_CAT_SIZE_W', NULL, '5', '5', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_CAT_USE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_FAVICON', NULL, 'favicon.ico', 'favicon.ico', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_FAVICON_IPAD', NULL, 'favicon.png', 'favicon.png', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_FAVICON_IPAD_USE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_FAVICON_USE', NULL, '1', '1', NULL, NULL, NULL),
	('gm_configuration/GM_LOGO_FLASH', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_FLASH_SIZE_H', NULL, '600', '600', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_FLASH_SIZE_W', NULL, '160', '160', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_FLASH_USE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_MAIL', NULL, 'email_logo.gif', 'email_logo.gif', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_MAIL_USE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_OVERLAY', NULL, 'overlay.gif', 'overlay.gif', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_OVERLAY_USE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_PDF', NULL, 'pdf_logo.gif', 'pdf_logo.gif', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_PDF_USE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_SHOP', NULL, 'gx4_shop_logo.svg', 'gx4_shop_logo.svg', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_SHOP_SIZE_H', NULL, '96', '96', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_SHOP_SIZE_W', NULL, '142', '142', NULL, NULL, NULL),
('gm_configuration/GM_LOGO_SHOP_USE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_NEW_PRODUCTS_STARTPAGE', NULL, '3', '3', NULL, NULL, NULL),
('gm_configuration/GM_NEWSLETTER_VVCODE', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_NEXT_INVOICE_ID', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_NEXT_PACKINGS_ID', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_ORDER_STATUS_CANCEL_ID', NULL, '99', '99', NULL, NULL, NULL),
('gm_configuration/GM_ORDER_STATUS_INVOICE_CREATED_ID', NULL, '149', '149', NULL, NULL, NULL),
('gm_configuration/GM_PACKINGS_ID', NULL, 'L_{DELIVERY_ID}_2020', 'L_{DELIVERY_ID}_2020', NULL, NULL, NULL),
('gm_configuration/GM_PASSWORD_ENCRYPTION_TYPE', NULL, 'password_hash', 'password_hash', NULL, NULL, NULL),
('gm_configuration/GM_PASSWORD_REENCRYPT', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ALLOW_COPYING', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ALLOW_MODIFYING', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ALLOW_NOTIFYING', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_BOTTOM_MARGIN', NULL, '10', '10', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CANCEL_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CANCEL_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CANCEL_FONT_SIZE', NULL, '11', '11', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CANCEL_FONT_STYLE', NULL, 'b', 'b', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CELL_HEIGHT', NULL, '5', '5', NULL, NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_LEFT_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_LEFT_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_LEFT_FONT_SIZE', NULL, '9', '9', NULL, NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_LEFT_FONT_STYLE', NULL, 'u', 'u', NULL, NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_RIGHT_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_RIGHT_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_RIGHT_FONT_SIZE', NULL, '11', '11', NULL, NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_RIGHT_FONT_STYLE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CONDITIONS_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CONDITIONS_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CONDITIONS_FONT_SIZE', NULL, '11', '11', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CONDITIONS_FONT_STYLE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CUSTOMER_ADR_POS', NULL, '50', '50', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CUSTOMER_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CUSTOMER_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CUSTOMER_FONT_SIZE', NULL, '11', '11', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CUSTOMER_FONT_STYLE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_DEFAULT_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_DEFAULT_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_DEFAULT_FONT_SIZE', NULL, '11', '11', NULL, NULL, NULL),
('gm_configuration/GM_PDF_DEFAULT_FONT_STYLE', NULL, 'b', 'b', NULL, NULL, NULL),
('gm_configuration/GM_PDF_DISPLAY_LAYOUT', NULL, 'continuous', 'continuous', NULL, NULL, NULL),
('gm_configuration/GM_PDF_DISPLAY_OUTPUT', NULL, 'I', 'I', NULL, NULL, NULL),
('gm_configuration/GM_PDF_DISPLAY_ZOOM', NULL, 'real', 'real', NULL, NULL, NULL),
('gm_configuration/GM_PDF_DRAW_COLOR', NULL, '#0065AC', '#0065AC', NULL, NULL, NULL),
('gm_configuration/GM_PDF_FIX_HEADER', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_FONT_SIZE', NULL, '10', '10', NULL, NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_FONT_STYLE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_CONDITIONS_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_CONDITIONS_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_CONDITIONS_FONT_SIZE', NULL, '11', '11', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_CONDITIONS_FONT_STYLE', NULL, 'b', 'b', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_FONT_SIZE', NULL, '11', '11', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_FONT_STYLE', NULL, 'b', 'b', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_MARGIN_BOTTOM', NULL, '15', '15', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_MARGIN_TOP', NULL, '15', '15', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_FONT_SIZE', NULL, '10', '10', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_FONT_STYLE', NULL, 'b', 'b', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_INFO_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_INFO_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_INFO_FONT_SIZE', NULL, '11', '11', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_ORDER_INFO_FONT_STYLE', NULL, 'b', 'b', NULL, NULL, NULL),
('gm_configuration/GM_PDF_INVOICE_USE_CURRENT_DATE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_INVOICE_DATE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_LEFT_MARGIN', NULL, '10', '10', NULL, NULL, NULL),
('gm_configuration/GM_PDF_LOGO_SRC', NULL, 'pdf_logo.gif', 'pdf_logo.gif', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_FONT_SIZE', NULL, '10', '10', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_FONT_STYLE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_INFO_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_INFO_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_INFO_FONT_SIZE', NULL, '11', '11', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_INFO_FONT_STYLE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_INFO_MARGIN_TOP', NULL, '30', '30', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_STATUS_INVOICE', NULL, '149', '149', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_STATUS_INVOICE_MAIL', NULL, '149', '149', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_TOTAL_FONT_COLOR', NULL, '#000000', '#000000', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_TOTAL_FONT_FACE', NULL, 'freesans', 'freesans', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_TOTAL_FONT_SIZE', NULL, '11', '11', NULL, NULL, NULL),
('gm_configuration/GM_PDF_ORDER_TOTAL_FONT_STYLE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_PACKING_SLIP_USE_CURRENT_DATE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_PACKING_SLIP_DATE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_RIGHT_MARGIN', NULL, '10', '10', NULL, NULL, NULL),
('gm_configuration/GM_PDF_TOP_MARGIN', NULL, '10', '10', NULL, NULL, NULL),
('gm_configuration/GM_PDF_MAX_AMOUNT_INVOICES_BULK_PDF', NULL, '100', '100', NULL, NULL, NULL),
('gm_configuration/GM_PDF_MAX_AMOUNT_PACKING_SLIPS_BULK_PDF', NULL, '100', '100', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_CONDITIONS', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_CUSTOMER_CODE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_CUSTOMER_COMMENT', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_DATE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_FOOTER', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_HEADER', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_INFO', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_INFO_TEXT', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_INVOICE_CODE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_ORDER_CODE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_ORDER_DATE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_PACKING_CODE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_PRODUCTS_MODEL', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PDF_USE_WITHDRAWAL', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_PRICE_OFFER_VVCODE', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_QUICK_SEARCH', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_RECAPTCHA_PRIVATE_KEY', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_RECAPTCHA_PUBLIC_KEY', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_REVIEWS_VVCODE', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_SEARCH_TIMELINE', NULL, '20', '20', NULL, NULL, NULL),
('gm_configuration/GM_SEARCH_TIMEOUT', NULL, '20', '20', NULL, NULL, NULL),
('gm_configuration/GM_SEARCH_TRYOUT', NULL, '2', '2', NULL, NULL, NULL),
('gm_configuration/GM_SEO_BOOST_CATEGORIES', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_SEO_BOOST_CONTENT', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_SEO_BOOST_PRODUCTS', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_SEO_BOOST_SHORT_URLS', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/GM_SET_OUT_OF_STOCK_PRODUCTS_INACTIVE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_SHOP_OFFLINE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/GM_SHOP_OFFLINE_MSG', NULL,
 '<p><font face=\"Arial\" size=\"2\">Unser Shop ist aufgrund von Wartungsarbeiten im Moment nicht erreichbar.<br />\r\n</font><font face=\"Arial\" size=\"2\">Bitte besuchen Sie uns zu einem späteren Zeitpunkt noch einmal.</font><br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<a href=\"login_admin.php\"><font color=\"#808080\">Login</font></a></p>',
 '<p><font face=\"Arial\" size=\"2\">Unser Shop ist aufgrund von Wartungsarbeiten im Moment nicht erreichbar.<br />\r\n</font><font face=\"Arial\" size=\"2\">Bitte besuchen Sie uns zu einem späteren Zeitpunkt noch einmal.</font><br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<br />\r\n<a href=\"login_admin.php\"><font color=\"#808080\">Login</font></a></p>',
 NULL, NULL, NULL),
('gm_configuration/GM_SHOW_ATTRIBUTES_STOCK', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_SHOW_CONDITIONS', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_SHOW_CONDITIONS_CONFIRMATION', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_SHOW_FLYOVER', NULL, '1', '1', NULL, NULL, NULL),
	('gm_configuration/GM_SHOW_IP', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_SHOW_PRIVACY_CONFIRMATION', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_SHOW_PRIVACY_ORDER', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_SHOW_PRIVACY_REGISTRATION', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_SHOW_PRIVACY_WITHDRAWAL_WEB_FORM', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_SHOW_PRIVACY_GV_SEND', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_SHOW_WISHLIST', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_SHOW_WITHDRAWAL', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_SHOW_WITHDRAWAL_CONFIRMATION', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_SITEMAP_GOOGLE_CHANGEFREQ', NULL, 'weekly', 'weekly', NULL, NULL, NULL),
('gm_configuration/GM_SITEMAP_GOOGLE_PRIORITY', NULL, '0.5', '0.5', NULL, NULL, NULL),
('gm_configuration/GM_SPECIALS_STARTPAGE', NULL, '6', '6', NULL, NULL, NULL),
('gm_configuration/GM_STARTPAGE_HOVER', NULL, '#b3ccdd', '#b3ccdd', NULL, NULL, NULL),
('gm_configuration/GM_STAT_PLOT_HEIGHT', NULL, '480', '480', NULL, NULL, NULL),
('gm_configuration/GM_STAT_PLOT_WIDTH', NULL, '640', '640', NULL, NULL, NULL),
('gm_configuration/GM_TELL_A_FRIEND', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/GM_TELL_A_FRIEND_USE_CUSTOMER_EMAIL', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_TELL_A_FRIEND_VVCODE', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_TEMPLATE_NAME', NULL, 'xtc4', 'xtc4', NULL, NULL, NULL),
('gm_configuration/GM_TITLE_SHOW_STANDARD_META_TITLE', NULL, 'before', 'before', NULL, NULL, NULL),
('gm_configuration/GM_TITLE_USE_STANDARD_META_TITLE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GM_TOPMENU_MODE', NULL, 'mode1', 'mode1', NULL, NULL, NULL),
('gm_configuration/GM_UNDERLINE_LINKS', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/GM_WITHDRAWAL_CONTENT_ID', NULL, '3889895', '3889895', NULL, NULL, NULL),
('gm_configuration/GM_WITHDRAWAL_CONTENT_ID_BACKUP', NULL, '9', '9', NULL, NULL, NULL),
('gm_configuration/GOOGLE_TAXONOMY_FILE_PATH', NULL,
 'http://www.google.com/basepages/producttype/taxonomy.de-DE.txt',
 'http://www.google.com/basepages/producttype/taxonomy.de-DE.txt', NULL, NULL, NULL),
('gm_configuration/LANGUAGE_PHRASE_CACHE_PRIORITIES', NULL,
 'original_sections,theme_sections,module_sections,user_sections,language_phrases_edited',
 'original_sections,theme_sections,module_sections,user_sections,language_phrases_edited', NULL, NULL, NULL),
('gm_configuration/MAIL_TEMPLATES_CACHE_PRIORITIES', NULL,
 'original_mail_templates,user_mail_templates,email_templates_edited',
 'original_mail_templates,user_mail_templates,email_templates_edited', NULL, NULL, NULL),
('gm_configuration/MAIN_SHOW_ATTRIBUTES', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/MAIN_SHOW_GRADUATED_PRICES', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/MAIN_SHOW_QTY', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/MAIN_SHOW_QTY_INFO', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/MAIN_VIEW_MODE_TILED', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/NUMBER_OF_CUSTOMERS_PER_PAGE', NULL, '20', '20', NULL, NULL, NULL),
('gm_configuration/NUMBER_OF_ORDERS_PER_PAGE', NULL, '20', '20', NULL, NULL, NULL),
('gm_configuration/NUMBER_OF_PRODUCTS_PER_PAGE', NULL, '20', '20', NULL, NULL, NULL),
('gm_configuration/PERSISTENT_GLOBAL_FILTER', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/POPUP_NOTIFICATION_STATUS', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRICE_FILTER_FROM_ACTIVE', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/PRICE_FILTER_TO_ACTIVE', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/SECURE_TOKEN', NULL, '917f76ab5c3435026e8f6a7aca75458f', '917f76ab5c3435026e8f6a7aca75458f',
 NULL, NULL, NULL),
('gm_configuration/SHIPPING_INFOS_BACKUP', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/SHOW_ACCOUNT_WITHDRAWAL_LINK', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/SHOW_ADDITIONAL_FIELDS_PRODUCT_DETAILS', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/SHOW_FACEBOOK', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/SHOW_WHATSAPP', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/SHOW_FOOTER', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/SHOW_GALLERY', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/SHOW_MANUFACTURER_IMAGE_LISTING', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/SHOW_MANUFACTURER_IMAGE_PRODUCT_DETAILS', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/SHOW_OLD_DISCOUNT_PRICE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/SHOW_OLD_GROUP_PRICE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/SHOW_OLD_SPECIAL_PRICE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/SHOW_PINTEREST', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/SHOW_PRINT', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/SHOW_PRODUCTS_COUNT', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/SHOW_PRODUCT_RIBBONS', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/SHOW_RATING_IN_GRID_AND_LISTING', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/SHOW_SUBCATEGORIES', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/SHOW_TOP_COUNTRY_SELECTION', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/SHOW_TOP_CURRENCY_SELECTION', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/SHOW_TWITTER', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/SHOW_ZOOM', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/STARTPAGE_FILTER_ACTIVE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/SUPPRESS_INDEX_IN_URL', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/TAX_INFO_TAX_FREE', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/TOPBAR_NOTIFICATION_COLOR', NULL, '#ffffff', '#ffffff', NULL, NULL, NULL),
('gm_configuration/TOPBAR_NOTIFICATION_MODE', NULL, 'hideable', 'hideable', NULL, NULL, NULL),
('gm_configuration/TOPBAR_NOTIFICATION_STATUS', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/TRUNCATE_FLYOVER', NULL, '35', '35', NULL, NULL, NULL),
('gm_configuration/TRUNCATE_FLYOVER_TEXT', NULL, '150', '150', NULL, NULL, NULL),
('gm_configuration/TRUNCATE_PRODUCTS_HISTORY', NULL, '16', '16', NULL, NULL, NULL),
('gm_configuration/TRUNCATE_PRODUCTS_NAME', NULL, '40', '40', NULL, NULL, NULL),
('gm_configuration/TRUSTED_SHOP_ID', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/UPLOAD_CONTENT_EXTENSIONS', NULL, 'html,htm,xhtml,xml,txt,js,pdf',
 'html,htm,xhtml,xml,txt,js,pdf', NULL, NULL, NULL),
('gm_configuration/USE_SEO_BOOST_LANGUAGE_CODE', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/WITHDRAWAL_PDF_ACTIVE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/WITHDRAWAL_WEBFORM_ACTIVE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/ALWAYS_SHOW_CONTINUE_SHOPPING_BUTTON', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/USE_UPCOMING_PRODUCT_SWIPER_ON_INDEX', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/USE_TOP_PRODUCT_SWIPER_ON_INDEX', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/USE_SPECIAL_PRODUCT_SWIPER_ON_INDEX', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/USE_NEW_PRODUCT_SWIPER_ON_INDEX', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_REGISTRATION', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_CALLBACK', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_CONTACT', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_ASK_PRODUCT_QUESTION', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_FOUND_CHEAPER', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_REVIEWS', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_ACCOUNT_EDIT', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_ADDRESS_BOOK', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_NEWSLETTER', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_CHECKOUT_SHIPPING', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_CHECKOUT_PAYMENT', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_WITHDRAWAL_WEB_FORM', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/PRIVACY_CHECKBOX_GV_SEND', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/DATA_TRANSFER_TO_TRANSPORT_COMPANIES_STATUS', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/DATA_TRANSFER_TO_TRANSPORT_COMPANIES_REQUIRED', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/DATA_TRANSFER_TO_TRANSPORT_COMPANIES_SETTINGS', NULL, 'a:0:{}', 'a:0:{}', NULL, NULL, NULL),
('gm_configuration/USE_SMALLER_IMAGES_FOR_PRODUCTS', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/GRADUATED_ASSIGN', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/LAST_NEW_SHOP_URL_NOTIFY', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_RECOMMENDED_PRODUCTS_STARTPAGE', NULL, '10', '10', NULL, NULL, NULL),
('gm_configuration/MODULE_CENTER_RESPONSIVEFILEMANAGER_INSTALLED', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/SHOW_ABANDONMENT_OF_WITHDRAWL_DOWNLOAD', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/SHOW_ABANDONMENT_OF_WITHDRAWL_SERVICE', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/CHECK_ABANDONMENT_OF_WITHDRAWL_DOWNLOAD', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/CHECK_ABANDONMENT_OF_WITHDRAWL_SERVICE', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/MODULE_CENTER_GAMBIOSUNNYCASH_INSTALLED', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/GM_CREATE_ACCOUNT_VVCODE', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/PRODUCT_REVIEW_NAME', NULL, 'short_nothing', 'short_nothing', NULL, NULL, NULL),
('gm_configuration/LOG_IP_CALLBACK', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/LOG_IP_CONTACT', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/LOG_IP_TELL_A_FRIEND', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/LOG_IP_FOUND_CHEAPER', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/LOG_IP_REVIEWS', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/LOG_IP_ACCOUNT_CONTACT', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/LOG_IP_ACCOUNT_ADDRESS_BOOK', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/LOG_IP_ACCOUNT_NEWSLETTER', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/LOG_IP_WITHDRAWAL_WEB_FORM', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/LOG_IP_GV_SEND', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/LOG_IP_SHIPPING', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/LOG_IP_ORDER_SHIPPING_ADDRESS', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/LOG_IP_ORDER_PAYMENT_ADDRESS', NULL, '0', '0', NULL, NULL, NULL),
('gm_configuration/SHOW_PRODUCTS_MODEL_IN_SHOPPING_CART_AND_WISHLIST', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/SHOW_PRODUCTS_MODEL_IN_PRODUCT_DETAILS', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/SHOW_PRODUCTS_MODEL_IN_PRODUCT_LISTS', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/SHOW_RATING_AS_TAB', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/CATEGORY_UNFOLD_DEFAULT_LEVEL', NULL, '10', '10', NULL, NULL, NULL),
('gm_configuration/MODULE_CENTER_GAMBIODIRECTHELP_INSTALLED', NULL, '1', '1', NULL, NULL, NULL),
('gm_configuration/GALLERY_LIGHTBOX', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/ENABLE_JS_HYPHENATION', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/ENABLE_LIVE_SEARCH', NULL, 'true', 'true', NULL, NULL, NULL),
('gm_configuration/DISPLAY_OF_PROPERTY_COMBINATION_SELECTION', NULL, 'DISPLAY_ONLY_PROPERTY_IMAGES', 'DISPLAY_ONLY_PROPERTY_IMAGES', NULL, NULL, NULL),
('gm_configuration/PDF_FOOTER_REPLACE_COLUMN', NULL, 'null', 'null', NULL, NULL, NULL),
('gm_configuration/AUTO_UPDATER_UPDATES_URL', NULL, 'https://updates.gambio-support.de/v2/check.php',
 'https://updates.gambio-support.de/v2/check.php', NULL, NULL, NULL),
('gm_configuration/AUTO_UPDATER_FEEDBACK_URL', NULL, 'https://updates.gambio-support.de/v2/callingHome.php',
 'https://updates.gambio-support.de/v2/callingHome.php', NULL, NULL, NULL),
('gm_configuration/AUTO_UPDATER_ACCEPT_DATA_PROCESSING', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/GAMBIO_STORE_URL', NULL, 'https://store.gambio.com/a', 'https://store.gambio.com/a', NULL, NULL,
 NULL),
('gm_configuration/GAMBIO_STORE_IS_REGISTERED', NULL, 'false', 'false', NULL, NULL, NULL),
('gm_configuration/GAMBIO_STORE_TOKEN', NULL, '', '', NULL, NULL, NULL),
('gm_configuration/EMAIL_BILLING_SUBJECT_ORDER', 1, 'Your order {$nr}, {$date}', 'Your order {$nr}, {$date}', NULL,
 NULL, 0),
('gm_configuration/EMAIL_BILLING_SUBJECT_ORDER', 2, 'Ihre Bestellung {$nr}, am {$date}',
 'Ihre Bestellung {$nr}, am {$date}', NULL, NULL, 0),
('gm_configuration/GM_PDF_COMPANY_ADRESS_LEFT', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_ADRESS_LEFT', 2, 'Ihr Name, Ihre Strasse 1, 12345 Ihr Ort',
 'Ihr Name, Ihre Strasse 1, 12345 Ihr Ort', NULL, NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_ADRESS_RIGHT', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_COMPANY_ADRESS_RIGHT', 2, 'Ihr Name \nIhre Strasse 1 \n\n12345 Ihr Ort',
 'Ihr Name \nIhre Strasse 1 \n\n12345 Ihr Ort', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CONDITIONS', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_CONDITIONS', 2, 'Hier könnten Ihre AGB stehen.', 'Hier könnten Ihre AGB stehen.', NULL,
 NULL, NULL),
('gm_configuration/GM_PDF_EMAIL_SUBJECT', 1,
 'Your invoice no. {INVOICE_ID} of your order no. {ORDER_ID} from {DATE}',
 'Your invoice no. {INVOICE_ID} of your order no. {ORDER_ID} from {DATE}', NULL, NULL, 0),
('gm_configuration/GM_PDF_EMAIL_SUBJECT', 2,
 'Ihre Rechnung Nr. {INVOICE_ID} zur Bestellung Nr. {ORDER_ID} vom {DATE}',
 'Ihre Rechnung Nr. {INVOICE_ID} zur Bestellung Nr. {ORDER_ID} vom {DATE}', NULL, NULL, 0),
('gm_configuration/GM_PDF_INVOICES_EMAIL_SUBJECT', 1, 'Your invoices of your order no. {ORDER_ID} from {DATE}',
 'Your invoices of your order no. {ORDER_ID} from {DATE}', NULL, NULL, 0),
('gm_configuration/GM_PDF_INVOICES_EMAIL_SUBJECT', 2, 'Ihre Rechnungen zur Bestellung Nr. {ORDER_ID} vom {DATE}',
 'Ihre Rechnungen zur Bestellung Nr. {ORDER_ID} vom {DATE}', NULL, NULL, 0),
('gm_configuration/GM_PDF_SALUTATION_MALE', 1, 'Mr.', 'Mr.', NULL, NULL, 0),
('gm_configuration/GM_PDF_SALUTATION_MALE', 2, 'geehrter Herr', 'geehrter Herr', NULL, NULL, 0),
('gm_configuration/GM_PDF_SALUTATION_FEMALE', 1, 'Mrs.', 'Mrs.', NULL, NULL, 0),
('gm_configuration/GM_PDF_SALUTATION_FEMALE', 2, 'geehrte Frau', 'geehrte Frau', NULL, NULL, 0),
('gm_configuration/GM_PDF_FOOTER_CELL_1', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_CELL_1', 2, 'Ihr Name \nIhre Strasse 1 \n\n12345 Ihr Ort',
 'Ihr Name \nIhre Strasse 1 \n\n12345 Ihr Ort', NULL, NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_CELL_2', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_CELL_2', 2, 'Ihre Telefonnummer\nIhre Faxnummer\nIhre Homepage\nIhre E-Mail',
 'Ihre Telefonnummer\nIhre Faxnummer\nIhre Homepage\nIhre E-Mail', NULL, NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_CELL_3', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_CELL_3', 2,
 'Ihre Steuernummer\nIhre Ust. ID. Nr.\nIhre Gerichtsbarkeit\nIhre Informationen',
 'Ihre Steuernummer\nIhre Ust. ID. Nr.\nIhre Gerichtsbarkeit\nIhre Informationen', NULL, NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_CELL_4', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_FOOTER_CELL_4', 2, 'Zusätzliche\nInformationen\nin der vierten\nSpalte\n',
 'Zusätzliche\nInformationen\nin der vierten\nSpalte\n', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_CONDITIONS', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_CONDITIONS', 2, 'Unsere AGB', 'Unsere AGB', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_INFO_TEXT_INVOICE', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_INFO_TEXT_INVOICE', 2, 'Rechnungshinweis', 'Rechnungshinweis', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_INFO_TEXT_PACKINGSLIP', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_INFO_TEXT_PACKINGSLIP', 2, 'Lieferhinweis', 'Lieferhinweis', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_INVOICE', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_INVOICE', 2, 'Ihre Rechnung', 'Ihre Rechnung', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_CANCELLATION_INVOICE', 1,
 'Your cancellation invoice to invoice number {INVOICE_ID} on {DATE}',
 'Your cancellation invoice to invoice number {INVOICE_ID} on {DATE}', NULL, NULL, 0),
('gm_configuration/GM_PDF_HEADING_CANCELLATION_INVOICE', 2,
 'Ihre Stornorechnung zur Rechnungsnummer {INVOICE_ID} vom {DATE}',
 'Ihre Stornorechnung zur Rechnungsnummer {INVOICE_ID} vom {DATE}', NULL, NULL, 0),
('gm_configuration/GM_PDF_HEADING_PACKINGSLIP', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_PACKINGSLIP', 2, 'Ihr Lieferschein', 'Ihr Lieferschein', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_WITHDRAWAL', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_HEADING_WITHDRAWAL', 2, 'Unser Widerrufsrecht', 'Unser Widerrufsrecht', NULL, NULL,
 NULL),
('gm_configuration/GM_PDF_INFO_TEXT_INVOICE', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_INFO_TEXT_INVOICE', 2, 'Ihr Hinweistext für die Rechnung',
 'Ihr Hinweistext für die Rechnung', NULL, NULL, NULL),
('gm_configuration/GM_PDF_INFO_TEXT_PACKINGSLIP', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_INFO_TEXT_PACKINGSLIP', 2, 'Ihr Hinweistext für den Lieferschein',
 'Ihr Hinweistext für den Lieferschein', NULL, NULL, NULL),
('gm_configuration/GM_PDF_INFO_TITLE_INVOICE', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_INFO_TITLE_INVOICE', 2, 'Beachten Sie bitte', 'Beachten Sie bitte', NULL, NULL, NULL),
('gm_configuration/GM_PDF_INFO_TITLE_PACKINGSLIP', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_INFO_TITLE_PACKINGSLIP', 2, 'Beachten Sie bitte', 'Beachten Sie bitte', NULL, NULL,
 NULL),
('gm_configuration/GM_PDF_WITHDRAWAL', 1, '', '', NULL, NULL, NULL),
('gm_configuration/GM_PDF_WITHDRAWAL', 2, 'Hier könnte Ihr Widerrufsrecht stehen.',
 'Hier könnte Ihr Widerrufsrecht stehen.', NULL, NULL, NULL),
('gm_configuration/GM_TITLE_STANDARD_META_TITLE', 1, '', '', NULL, NULL, 0),
('gm_configuration/GM_TITLE_STANDARD_META_TITLE', 2, '', '', NULL, NULL, 0);

INSERT INTO `gx_configurations` (`key`, `language_id`, `value`, `default`, `type`, `sort_order`,
                                 `legacy_group_id`)
VALUES ('gm_configuration/GM_TITLE_STANDARD_META_TITLE_SEPARATOR', 1, ' - ', ' - ', NULL, NULL, 0),
('gm_configuration/GM_TITLE_STANDARD_META_TITLE_SEPARATOR', 2, ' - ', ' - ', NULL, NULL, 0),
	('gm_configuration/keywords', 1, '', '', NULL, NULL, 9999),
('gm_configuration/keywords', 2, 'keywords,kommagetrennt', 'keywords,kommagetrennt', NULL, NULL, 9999),
('gm_configuration/robots', 1, 'index,follow', 'index,follow', NULL, NULL, 9999),
('gm_configuration/robots', 2, 'index,follow', 'index,follow', NULL, NULL, 9999),
('gm_configuration/SEND_X_FRAME_OPTIONS_SAMEORIGIN_HEADER', NULL, 'true', 'true', 'switcher', NULL, NULL),
('error_pages/customPageNotFound', NULL, 'true', 'true', NULL, NULL, NULL),
('error_pages/errorHtml', NULL,
 '{\r\n	  \"DE\": \"<center><b>Leider ist ein unerwarteter Fehler aufgetreten.</b></center>\",\r\n	  \"EN\": \"<center><b>Unfortunately an unexpected error occurred.</b></center>\"\r\n  }',
 '{\r\n	  \"DE\": \"<center><b>Leider ist ein unerwarteter Fehler aufgetreten.</b></center>\",\r\n	  \"EN\": \"<center><b>Unfortunately an unexpected error occurred.</b></center>\"\r\n  }',
 NULL, NULL, NULL),
('error_pages/notFoundHtml', NULL,
 '{\r\n	  \"DE\": \"<center><b>Die aufgerufene Seite konnte nicht gefunden werden.</b></center>\",\r\n	  \"EN\": \"<center><b>The requested page could not be found.</center>\"\r\n  }',
 '{\r\n	  \"DE\": \"<center><b>Die aufgerufene Seite konnte nicht gefunden werden.</b></center>\",\r\n	  \"EN\": \"<center><b>The requested page could not be found.</center>\"\r\n  }',
 NULL, NULL, NULL),
('error_pages/userFriendlyErrorHandling', NULL, 'true', 'true', NULL, NULL, NULL),
('modules/admin/responsivefilemanager/use_in_attribute_pages', NULL, '1', '1', NULL, NULL, NULL),
('modules/admin/responsivefilemanager/use_in_banner_manager_pages', NULL, '1', '1', NULL, NULL, NULL),
('modules/admin/responsivefilemanager/use_in_ckeditor', NULL, '1', '1', NULL, NULL, NULL),
('modules/admin/responsivefilemanager/use_in_content_manager_pages', NULL, '1', '1', NULL, NULL, NULL),
('modules/admin/responsivefilemanager/use_in_email_pages', NULL, '1', '1', NULL, NULL, NULL),
('modules/admin/responsivefilemanager/use_in_manufacturer_pages', NULL, '1', '1', NULL, NULL, NULL),
('modules/admin/responsivefilemanager/use_in_product_and_category_pages', NULL, '1', '1', NULL, NULL, NULL),
('modules/admin/responsivefilemanager/use_in_shipping_status_pages', NULL, '1', '1', NULL, NULL, NULL),
('modules/GambioDirectHelp/active', NULL, '1', '1', NULL, NULL, NULL),
('modules/GambioSunnyCash/active', NULL, '0', '0', NULL, NULL, NULL),
       ('extensions/giftsystem/releaseOrderStatuses', NULL, '', '', NULL, NULL, NULL),
('extensions/giftsystem/securityCodeLength', NULL, '10', '10', NULL, NULL, NULL),
('extensions/giftsystem/newSignupGiftVoucherAmount', NULL, '0', '0', NULL, NULL, NULL),
('extensions/giftsystem/newSignupDiscountCoupon', NULL, '', '', NULL, NULL, NULL);
